﻿
using System;
using System.Collections.Generic;
using System.Text;
using Gemini.Core.BL.Interface.DBD;

namespace PI.ZB.N1200.ELearning.BL.DAL
{
    internal class CompetencePart_Class : PI.FM.N000.Base.BL.DAL.BaseTable<DBD.CompetencePart_Class, BO.CompetencePart_Class>
    {

        internal CompetencePart_Class(Gemini.Core.BL.Interface.IBusinessLogicPlugIn BusinessLogicPlugIn) : this(BusinessLogicPlugIn.Environment, BusinessLogicPlugIn.DriverName) { }

        internal CompetencePart_Class(Gemini.Core.BL.Interface.DAL.IEnvironment Environment, string DriverName) : base(Environment, DriverName, DBD.CompetencePart_Class.DBD) { }

        internal List<BO.CompetencePart_Class> Restore(BO.CompetencePart_Class.Search Search)
        {
            return InternalRestoreList((int)DBD.CompetencePart_Class.Commands.RestoreBySearch,
                delegate(Gemini.Core.BL.Interface.DBD.ICommand Command)
                {
                    Command["ClassID"].Value = Search.ClassID;
                    Command["CompetencePartID"].Value = Search.CompetencePartID;
                }
            );
        }

        internal BO.CompetencePart_Class RestoreTopOne(BO.CompetencePart_Class.Search Search)
        {
            return InternalRestoreOne((int)DBD.CompetencePart_Class.Commands.RestoreBySearch,
                delegate(Gemini.Core.BL.Interface.DBD.ICommand Command)
                {
                    Command["ClassID"].Value = Search.ClassID;
                    Command["CompetencePartID"].Value = Search.CompetencePartID;
                }
            );
        }

        internal bool Remove(BO.CompetencePart_Class.Search Search)
        {
            bool _return = false;
            Gemini.Core.BL.Interface.DBD.ICommand _command = InternalExecuteScalar((int)DBD.CompetencePart_Class.Commands.RemoveBySearch,
            delegate(Gemini.Core.BL.Interface.DBD.ICommand Command)
            {
                Command["ClassID"].Value = Search.ClassID;
                Command["CompetencePartID"].Value = Search.CompetencePartID;
                Command["EditDate"].Value = DateTime.Now;
                Command["EditUser"].Value = Environment.User.ID;
            });

            if (_command != null)
            {
                if (_command.ResultParam != null)
                {
                    _return = _command.ResultParamValue >= 0 ? true : false;
                }
                else
                {
                    _return = true;
                }
            }
            return _return;
        }
    }
}
